from pydantic import BaseModel

# Dla ułatwienia: klasa ItemIn wskazuje jakie dane zostaną odebrane
class ItemIn(BaseModel):
    name: str
    price: float

# Endpoint POST (może mieć taką samą nazwę jak inny endpoint typu GET)
# item: ItemIn w funkcji tworzy parametr i od razu wskazuje klasę ItemIn
# Umożliwia to wykorzystanie item.name, item.price
@app.post("/items")
def create_item(item: ItemIn):
    conn = get_connection()
    cursor = conn.cursor()

    query = "INSERT INTO table_name (column_name_1, column_name_2) VALUES (%s, %s)"
    values = (item.name, item.price)

    cursor.execute(query, values)
    conn.commit()

    new_id = cursor.lastrowid

    cursor.close()
    conn.close()

    return {
        "status": "ok",
        "id": new_id,
        "name": item.name,
        "price": item.price
    }
